// $(baseName)_AppUi.cpp
// ----------------------------
//
// Copyright (c) 2000 Symbian Ltd.  All rights reserved.
//

////////////////////////////////////////////////////////////////////////
//
// Source file for the implementation of the
// application UI class - C$(baseName)AppUi
//
////////////////////////////////////////////////////////////////////////

#include "$(baseName).h"

//             The second phase constructor of the application UI class.
//             The application UI creates and owns the one and only view.
//
void C$(baseName)AppUi::ConstructL()
    {
	           // BaseConstructL() completes the UI framework's
	           // construction of the App UI.
    BaseConstructL();
	           // Create the single application view in which to
	           // draw the text "$(message)", passing into it
	           // the rectangle available to it.
	iAppView = C$(baseName)AppView::NewL(ClientRect());
	}


//             The app Ui owns the two views and is.
//             therefore, responsible for destroying them
//
C$(baseName)AppUi::~C$(baseName)AppUi()
	{
	delete iAppView;
	}


//             Called by the UI framework when a command has been issued.
//             In this application, a command can originate through a
//             hot-key press or by selection of a menu item.
//             The command Ids are defined in the .hrh file
//             and are 'connected' to the hot-key and menu item in the
//             resource file.
//             Note that the EEikCmdExit is defined by the UI
//             framework and is pulled in by including eikon.hrh
//
void C$(baseName)AppUi::HandleCommandL(TInt aCommand)
	{
	switch (aCommand)
		{
		      // Just issue simple info messages to show that
		      // the menu items have been selected
	case E$(baseName)Item0:
		iEikonEnv->InfoMsg(R_EXAMPLE_TEXT_ITEM0);
		break;


	case E$(baseName)Item1:
		iEikonEnv->InfoMsg(R_EXAMPLE_TEXT_ITEM1);
		break;

	case E$(baseName)Item2:
		iEikonEnv->InfoMsg(R_EXAMPLE_TEXT_ITEM2);
		break;
               // Exit the application. The call is
		       // implemented by the UI framework.

	case EEikCmdExit:
		Exit();
		break;
		}
	}

